"use client";

import Link from "next/link";
import { siteName } from "../lib/utilities/generic";

const githubIcon = () => {
  return (
    <svg
      fill="currentColor"
      viewBox="0 0 24 24"
      className="h-6 w-6"
      aria-hidden="true"
    >
      <path
        fillRule="evenodd"
        d="M12 2C6.477 2 2 6.484 2 12.017c0 4.425 2.865 8.18 6.839 9.504.5.092.682-.217.682-.483 0-.237-.008-.868-.013-1.703-2.782.605-3.369-1.343-3.369-1.343-.454-1.158-1.11-1.466-1.11-1.466-.908-.62.069-.608.069-.608 1.003.07 1.531 1.032 1.531 1.032.892 1.53 2.341 1.088 2.91.832.092-.647.35-1.088.636-1.338-2.22-.253-4.555-1.113-4.555-4.951 0-1.093.39-1.988 1.029-2.688-.103-.253-.446-1.272.098-2.65 0 0 .84-.27 2.75 1.026A9.564 9.564 0 0112 6.844c.85.004 1.705.115 2.504.337 1.909-1.296 2.747-1.027 2.747-1.027.546 1.379.202 2.398.1 2.651.64.7 1.028 1.595 1.028 2.688 0 3.848-2.339 4.695-4.566 4.943.359.309.678.92.678 1.855 0 1.338-.012 2.419-.012 2.747 0 .268.18.58.688.482A10.019 10.019 0 0022 12.017C22 6.484 17.522 2 12 2z"
        clipRule="evenodd"
      />
    </svg>
  );
};

const mastodonIcon = () => {
  return (
    <svg
      fill="currentColor"
      viewBox="0 0 512 512"
      className="h-6 w-6"
      aria-hidden="true"
    >
      <path
        fillRule="evenodd"
        d="M480,173.59c0-104.13-68.26-134.65-68.26-134.65C377.3,23.15,318.2,16.5,256.8,16h-1.51c-61.4.5-120.46,7.15-154.88,22.94,0,0-68.27,30.52-68.27,134.65,0,23.85-.46,52.35.29,82.59C34.91,358,51.11,458.37,145.32,483.29c43.43,11.49,80.73,13.89,110.76,12.24,54.47-3,85-19.42,85-19.42l-1.79-39.5s-38.93,12.27-82.64,10.77c-43.31-1.48-89-4.67-96-57.81a108.44,108.44,0,0,1-1-14.9,558.91,558.91,0,0,0,96.39,12.85c32.95,1.51,63.84-1.93,95.22-5.67,60.18-7.18,112.58-44.24,119.16-78.09C480.84,250.42,480,173.59,480,173.59ZM399.46,307.75h-50V185.38c0-25.8-10.86-38.89-32.58-38.89-24,0-36.06,15.53-36.06,46.24v67H231.16v-67c0-30.71-12-46.24-36.06-46.24-21.72,0-32.58,13.09-32.58,38.89V307.75h-50V181.67q0-38.65,19.75-61.39c13.6-15.15,31.4-22.92,53.51-22.92,25.58,0,44.95,9.82,57.75,29.48L256,147.69l12.45-20.85c12.81-19.66,32.17-29.48,57.75-29.48,22.11,0,39.91,7.77,53.51,22.92Q399.5,143,399.46,181.67Z"
        clipRule="evenodd"
      />
    </svg>
  );
};

const footerNavigation = {
  main: [
    { name: "About", to: "/about" },
    { name: "Authentication", to: "/authentication" },
    { name: "Blog", to: "/blog" },
  ],
  social: [
    {
      name: "GitHub",
      // TODO: Switch to mongo-labs
      href: "https://github.com/mongodb-labs/full-stack-fastapi-mongodb",
      icon: githubIcon,
    },
    {
      name: "Mastodon",
      // TODO: Switch to mongo-labs?
      href: "https://wandering.shop/@GavinChait",
      icon: mastodonIcon,
    },
  ],
};

const renderNavigation = () => {
  return footerNavigation.main.map((item) => (
    <div key={item.name} className="px-5 py-2">
      <Link
        href={item.to}
        className="text-base text-gray-400 hover:text-gray-300"
      >
        {item.name}
      </Link>
    </div>
  ));
};

const renderSocials = () => {
  return footerNavigation.social.map((item) => (
    <a
      key={item.name}
      href={item.href}
      className="text-gray-400 hover:text-gray-300"
    >
      <span className="sr-only">{item.name}</span>
      {item.icon()}
    </a>
  ));
};

export default function Footer() {
  return (
    <footer className="mt-24 bg-gray-900 sm:mt-12">
      <div className="mx-auto max-w-md overflow-hidden py-12 px-4 sm:max-w-3xl sm:px-6 lg:max-w-7xl lg:px-8">
        <nav
          className="-mx-5 -my-2 flex flex-wrap justify-center"
          aria-label="Footer"
        >
          {renderNavigation()}
        </nav>
        <div className="mt-8 flex justify-center space-x-6">
          {renderSocials()}
        </div>
        <div className="flex justify-between">
          <p className="mt-8 text-center text-base text-gray-400">
            &copy; 2023 {siteName}. All rights reserved.
          </p>
        </div>
      </div>
    </footer>
  );
}
